# number of timesteps to iterate the model
t_max = 15

# initial population size
N0 = 20

# intrinsic population growth rate
r = 0.8

# carrying capacity
K = 100

# initialise an empty vector to store the population sizes
# over time
Ns_logistic = numeric(t_max+1)
# set the population size in the first timestep to N0
Ns_logistic[1] = N0

# execute a loop from time t=1 to t_max, iterating the model
for ( t in 1:t_max )
  Ns_logistic[t+1] = Ns_logistic[t]*
                     (1+r*(1-Ns_logistic[t]/K))

# plot the results
plot(0:t_max,Ns_logistic,pch=19,type='o',col='red',
     xlab='t',ylab='N',ylim=c(0,105)) 

# density dependence parameter for Beverton-Holt model
a_BH = 0.008
Ns_BH = numeric(t_max+1)
Ns_BH[1] = N0
for ( t in 1:t_max )
  Ns_BH[t+1] = (1+r)*Ns_BH[t]/(1+a_BH*Ns_BH[t])
points(0:t_max,Ns_BH,pch=17,type='o',col='forest green')

# density dependence parameter for Ricker model
a_Ricker = 0.0059
Ns_Ricker = numeric(t_max+1)
Ns_Ricker[1] = N0
for ( t in 1:t_max )
  Ns_Ricker[t+1] = (1+r)*Ns_Ricker[t]*
                   exp(-a_Ricker*Ns_Ricker[t])
points(0:t_max,Ns_Ricker,pch=15,type='o',col='blue')
